<?php

namespace App\Models\Tenant\Inventory;

use App\Models\Tenant\Inventory\Item;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model
{
    use HasFactory, SoftDeletes;
    
    protected $table = 'item_categories';
    protected $fillable = ['name'];

    public function items()
    {
        return $this->hasMany(Item::class, 'category_id');
    }
}
