<?php

namespace App\Models\Tenant\Inventory;

use App\Models\Tenant\Inventory\Item;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Department extends Model
{

    use HasFactory, SoftDeletes;

    protected $table = 'item_departments';
    protected $fillable = ['department_name'];

    public function items()
    {
        return $this->hasMany(Item::class, 'department_id');
    }
}
