<?php

namespace App\Models\Tenant\Inventory;

use App\Models\Tenant\Patient\Patient;
use App\Models\Tenant\Treatment\Treatment;
use App\Models\Tenant\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InventoryUsage extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'inventory_usages';

    protected $fillable = [
        'store_id',
        'usage_date',
        'reference',
        'notes',
        'patient_id',
        'doctor_id',
        'treatment_id',
        'created_by',
        'branch_id',
        'status',
    ];

    protected $dates = [
        'usage_date',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    // 🧾 Relationship: One usage has many items
    public function items()
    {
        return $this->hasMany(InventoryUsageItems::class, 'usage_id');
    }

    // 🏪 Relationship: belongs to store
    public function store()
    {
        return $this->belongsTo(Store::class, 'store_id');
    }

    // 👤 Relationship: created by user
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    // 🧑‍⚕️ Optional relationships
    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id');
    }

    public function doctor()
    {
        return $this->belongsTo(User::class, 'doctor_id');
    }

    public function treatment()
    {
        return $this->belongsTo(Treatment::class, 'treatment_id');
    }
}
