<?php

namespace App\Models\Tenant\Inventory;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ItemType extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'item_types';

    protected $fillable = ['name', 'cogs_account', 'income_account'];

    public function items()
    {
        return $this->hasMany(Item::class, 'item_type');
    }
}
