<?php

namespace App\Models\Tenant\Inventory;

use App\Models\Tenant\Inventory\Item;
use App\Models\Tenant\Branch;
use App\Models\Tenant\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Movement extends Model
{
     use HasFactory, SoftDeletes;

    protected $table = 'inventory_movements';
    protected $fillable = [
        'item_id',
        'branch_id',
        'movement_type',
        'quantity',
        'cost_price',
        'batch_number',
        'expiry_date',
        'serial_number',
        'reference_type',
        'reference_id',
        'notes',
        'created_by',
    ];

    protected $casts = [
        'quantity' => 'decimal:2',
        'cost_price' => 'decimal:2',
        'expiry_date' => 'date',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relationships
    |--------------------------------------------------------------------------
    */

    public function item()
    {
        return $this->belongsTo(Item::class);
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    /**
     * Polymorphic relation placeholder if reference_type refers to another model
     */
    public function reference()
    {
        return $this->morphTo(__FUNCTION__, 'reference_type', 'reference_id');
    }
}
