<?php

namespace App\Models\Tenant\Inventory;

use App\Models\Tenant\User;
use App\Models\Tenant\Branch;
use App\Models\Tenant\Inventory\Vendor;
use App\Models\Tenant\Inventory\PurchaseBillItem;


use Illuminate\Database\Eloquent\Model;

class PurchaseBill extends Model
{
    protected $table = 'purchase_bills';

    protected $fillable = [
        'bill_date',
        'due_date',
        'reference_no',
        'supplier_id',
        'total_amount',
        'note',
        'created_by',
        'branch_id',
        'paid_amount',
        'status',
    ];

    protected $casts = [
        'bill_date' => 'date',
        'due_date' => 'datetime',
        'paid_amount' => 'decimal:2',
        'total_amount' => 'decimal:2',
    ];

    public function items()
    {
        return $this->hasMany(PurchaseBillItem::class, 'bill_id');
    }

    public function supplier()
    {
        return $this->belongsTo(Vendor::class, 'supplier_id');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
