<?php

namespace App\Models\Tenant\Inventory;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use App\Models\Tenant\Inventory\PurchaseBill;
use App\Models\Tenant\Inventory\Item;
use App\Models\Tenant\Inventory\UnitConversion;

class PurchaseBillItem extends Model
{
   use HasFactory;

    protected $table = 'purchase_bill_items';

    protected $fillable = [
        'bill_id',
        'item_id',
        'description',
        'quantity',
        'unit_id',
        'multiplier',
        'cost',
        'batch_number',
        'total',
        'expiry_date',
    ];

    protected $casts = [
        'quantity' => 'decimal:4',
        'multiplier' => 'decimal:4',
        'cost' => 'decimal:4',
        'total' => 'decimal:2',
        'expiry_date' => 'datetime',
    ];

    // 🔗 Relationships (optional - uncomment if related models exist)
    public function bill()
    {
        return $this->belongsTo(PurchaseBill::class, 'bill_id');
    }

    public function item()
    {
        return $this->belongsTo(Item::class, 'item_id');
    }

    public function unit()
    {
        return $this->belongsTo(UnitConversion::class, 'unit_id');
    }
}
