<?php

namespace App\Models\Tenant\Inventory;

use App\Models\Tenant\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StockAdjustment extends Model
{
    use HasFactory;

    protected $table = 'stock_adjustments';

    protected $fillable = [
        'adjustment_date',
        'reason',
        'account_id',
        'total_value',
        'created_by',
        'branch_id',
    ];

    protected $dates = [
        'adjustment_date',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    // Relationship: one adjustment has many items
    public function items()
    {
        return $this->hasMany(StockAdjustmentItem::class, 'stock_adjustment_id');
    }

    // Relationship: adjustment reason (optional)
    public function reasonDetail()
    {
        return $this->belongsTo(StockAdjustmentReason::class, 'reason');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
