<?php

namespace App\Models\Tenant\Inventory;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StockAdjustmentItem extends Model
{
    use HasFactory;

    protected $table = 'stock_adjustment_items';

    protected $fillable = [
        'stock_adjustment_id',
        'item_id',
        'batch_number',
        'quantity',
        'unit_cost',
        'adjustment_type',
        'note',
        'current_stock',
    ];

    // Relationship: belongs to a stock adjustment
    public function adjustment()
    {
        return $this->belongsTo(StockAdjustment::class, 'stock_adjustment_id');
    }

    // Relationship: belongs to an item (you may have Item model)
    public function item()
    {
        return $this->belongsTo(Item::class, 'item_id');
    }
}
