<?php

namespace App\Models\Tenant\Inventory;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StockAdjustmentReason extends Model
{
    use HasFactory;

    protected $table = 'stock_adjustment_reasons';

    protected $fillable = [
        'name',
        'account_id',
        'description',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // Relationship: reasons can be linked to multiple stock adjustments
    public function adjustments()
    {
        return $this->hasMany(StockAdjustment::class, 'reason', 'name');
    }
}
