<?php

namespace App\Models\Tenant\Inventory;

use App\Models\Tenant\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StockTransfer extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'inventory_transfers';

    protected $fillable = [
        'transfer_date',
        'from_store_id',
        'to_store_id',
        'reference_no',
        'notes',
        'created_by',
        'branch_id',
    ];

    protected $dates = [
        'transfer_date',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    // 🔁 Relationship: one transfer has many items
    public function items()
    {
        return $this->hasMany(StockTransferItem::class, 'transfer_id', 'id');
    }

    // 🏪 Relationship: source store
    public function fromStore()
    {
        return $this->belongsTo(Store::class, 'from_store_id');
    }

    // 🏬 Relationship: destination store
    public function toStore()
    {
        return $this->belongsTo(Store::class, 'to_store_id');
    }

    // 👤 Relationship: creator user
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
