<?php

namespace App\Models\Tenant\Inventory;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StockTransferItem extends Model
{
     use HasFactory, SoftDeletes;

    protected $table = 'inventory_transfer_items';

    protected $fillable = [
        'transfer_id',
        'item_id',
        'quantity',
        'unit_id',
        'batch_no',
        'expiry_date',
        'note',
    ];

    protected $dates = [
        'expiry_date',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    // 🔁 Relationship: belongs to a transfer
    public function transfer()
    {
        return $this->belongsTo(StockTransfer::class, 'transfer_id');
    }

    // 📦 Relationship: belongs to item
    public function item()
    {
        return $this->belongsTo(Item::class, 'item_id');
    }

    // ⚖️ Relationship: belongs to unit
    public function unit()
    {
        return $this->belongsTo(Unit::class, 'unit_id');
    }//

    
    // 📦 Relationship: belongs to batch
    public function batch()
    {
        return $this->belongsTo(Stock::class, 'batch_no');
    }


}
