<?php

namespace App\Models\Tenant\Inventory;

use App\Models\Tenant\Branch;
use App\Models\Tenant\User;
use App\Models\Tenant\UserProfile;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Store extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'inv_stores';

    protected $fillable = [
        'store_name',
        'doctor_ids',
        'room_numbers',
        'coa_account_id',
        'branch_id',
        'created_by',
        'is_main',
    ];

    protected $casts = [
        'doctor_ids' => 'array',
        'room_numbers' => 'array',
        'is_main' => 'boolean',
    ];

    /*
    |--------------------------------------------------------------------------
    | Relationships
    |--------------------------------------------------------------------------
    */

    /** The branch this store belongs to */
    public function branch()
    {
        return $this->belongsTo(Branch::class);
    }

    public function doctors()
    {
        return $this->belongsTo(UserProfile::class, 'created_by');
    }

    /** The user who created the store */
    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function isMainStore(): bool
    {
        return (bool) $this->is_main;
    }


    
}
