<?php

namespace App\Models\Tenant\Inventory;

use App\Models\Tenant\Inventory\Item;
use Illuminate\Database\Eloquent\Model;

class UnitConversion extends Model
{
    protected $table = 'unit_conversions';
    protected $fillable = [
        'item_id',
        'category',
        'from_unit_id',
        'to_unit_id',
        'multiplier'
    ];

    public function item()
    {
        return $this->belongsTo(Item::class);
    }

    public function fromUnit()
    {
        return $this->belongsTo(Unit::class, 'from_unit_id')->select('id','name');
    }

    public function toUnit()
    {
        return $this->belongsTo(Unit::class, 'to_unit_id')->select('id','name');
    }
}
