<?php

namespace App\Models\Tenant\Inventory;

use App\Models\Tenant\Patient\Patient;
use App\Models\Tenant\User;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Usage extends Model
{
    use HasFactory;

    protected $table = 'inventory_usages';

    protected $fillable = [
        'store_id',
        'usage_date',
        'reference',
        'notes',
        'patient_id',
        'doctor_id',
        'treatment_id',
        'created_by',
        'branch_id',
        'status',
    ];

    protected $casts = [
        'usage_date' => 'date',
        'status' => 'integer',
    ];

    /**
     * 🔗 Relationships
     */
    public function items()
    {
        return $this->hasMany(UsageItem::class, 'usage_id');
    }

    public function store()
    {
        return $this->belongsTo(Store::class, 'store_id');
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class, 'patient_id');
    }

    public function doctor()
    {
        return $this->belongsTo(User::class, 'doctor_id');
    }

    public function creator()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
}
