<?php

namespace App\Models\Tenant\Inventory;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UsageItem extends Model
{
    use HasFactory;

    protected $table = 'inventory_usage_items';

    protected $fillable = [
        'usage_id',
        'item_id',
        'quantity',
        'unit_id',
        'batch_id',
        'note',
    ];

    protected $casts = [
        'quantity' => 'decimal:2',
    ];

    /**
     * 🔗 Relationships
     */
    public function usage()
    {
        return $this->belongsTo(Usage::class, 'usage_id');
    }

    public function item()
    {
        return $this->belongsTo(Item::class, 'item_id');
    }



    public function unit()
    {
        return $this->belongsTo(Unit::class, 'unit_id');
    }

    public function batch()
    {
        return $this->belongsTo(Stock::class, 'batch_id');
    }
}
