<?php

namespace App\Models\Tenant\Inventory;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Vendor extends Model
{
    
    use HasFactory, SoftDeletes;
    protected $primaryKey = 'vendor_id';
    protected $table = 'inv_vendors';

    protected $fillable = [
        'name',
        'email',
        'phone',
        'address',
        'balance',
    ];

    protected $casts = [
        'balance' => 'decimal:2',
    ];

}
