const http = require('http');
const socketIo = require('socket.io');
const mysql = require('mysql');
const cors = require('cors');


// Create MySQL connection
const dbConnection = mysql.createConnection({
    host: 'localhost',
    user: 'java_hm_clinicaj',
    password: 'developer2123',
    database: 'java_hm_clinicajoelle01'
});


// Connect to MySQL
dbConnection.connect((err) => {
    if (err) {
        console.error('Error connecting to database:', err.stack);
        return;
    }
    console.log('Connected to database as id', dbConnection.threadId);
});

// Define CORS options
const corsOptions = {
  origin: 'https://clinicajoelle01.h-mate.com', // Allow requests from this origin
  methods: ['GET', 'POST'],   // Allow only GET and POST requests
  allowedHeaders: ['Content-Type'], // Allow only specified headers
};

// Create HTTP server
const server = http.createServer();
const io = socketIo(server, {
  cors: corsOptions // Apply CORS settings to Socket.io
});
require('./chat')(io,dbConnection); 
io.on('connection', (socket) => {
  console.log('A user connected');

  // Fetch queue numbers from database and emit to clients
 
  socket.on('queueUpdate', (data) => {
    console.log('all data');
    fetchQueueNumbers();
});


let lastConfig = {};
// const pollDatabase = () => {
//   const sql = 'SELECT * FROM queue_config LIMIT 1'; // Adjust this query as needed
//   dbConnection.query(sql, (err, result) => {
//       if (err) {
//           console.error(err);
//           return;
//       }

//       const newConfig = result[0];

//       if (JSON.stringify(newConfig) !== JSON.stringify(lastConfig)) {
//           lastConfig = newConfig;
//           io.emit('config_updated', newConfig);
//       }
//   });
// };

// // Poll every 5 seconds
// setInterval(pollDatabase, 5000);
  // Handle 'callNumber' event
  socket.on('callNumber', (data) => {
      console.log('callNumber received');
      callNumber(data);
  });
  socket.on('doneNumber', (data) => {
    
    fetchQueueNumbers();
});

socket.on('loadAppointment', () => {
  console.log('Load Appointment');
  io.emit('loadAppointment');
});
  // Handle disconnection
  socket.on('disconnect', () => {
      console.log('User disconnected');
  });
});


// Function to fetch queue numbers from database
function fetchQueueNumbers() {
    const query = 'SELECT queue.id, queue.number, tbl_users.full_name, queue.status,queue.type, tbl_resources.resource_name AS room_name FROM queue LEFT JOIN tbl_users ON tbl_users.user_Id = queue.doctor_id LEFT JOIN tbl_resources ON tbl_resources.resource_id = queue.room_number WHERE queue.status = 8 OR queue.status = 11 ORDER BY number ASC';
    dbConnection.query(query, (err, results) => {
        if (err) {
            console.error('Error fetching queue numbers:', err.stack);
            return;
        }

        // Extract queue numbers from results
        const queueNumbers = results.map(result => ({
            number: result.number,
            doctor_name: result.full_name,
            status: result.status,
            room_name: result.room_name,
            type:result.type,
            id: result.id
        }));

        // Emit queue numbers to connected clients
        io.emit('queueUpdate', { queue: queueNumbers });
    });
}

function callNumber(data) {
  console.log(data);

  let query;
  let params;

  if (data.room_number) {
    // If room_number is provided
    query = 'SELECT queue.id, queue.number,queue.type, tbl_resources.resource_name as full_name, queue.status FROM queue LEFT JOIN tbl_resources ON tbl_resources.resource_id = queue.room_number WHERE queue.room_number = ? AND queue.patient_id = ? ORDER BY queue.number ASC LIMIT 1';
    params = [data.room_number, data.patient_id];
  } else {
    // If doctor_id is provided
    query = 'SELECT queue.id, queue.number,queue.type, tbl_users.full_name, queue.status FROM queue LEFT JOIN tbl_users ON tbl_users.user_Id = queue.doctor_id WHERE queue.doctor_id = ? AND queue.patient_id = ? ORDER BY queue.number ASC LIMIT 1';
    params = [data.doctor_id, data.patient_id];
  }

  dbConnection.query(query, params, (err, results) => {
    if (err) {
      console.error('Error fetching queue numbers:', err.stack);
      return;
    }

    // Extract queue numbers from results
    if (results.length > 0) {
      const queueNumber = {
        number: results[0].number,
        doctor_name: results[0].full_name,
        status: results[0].status,
        id: results[0].id,
        type: results[0].type,
      };
      console.log(queueNumber);

      // Emit the single queue number to connected clients
      io.emit('queueNewNumber', { queue: queueNumber });
    } else {
      console.log('No queue number found for the given doctor/room and patient ID.');
    }
  });
}

function doneNumber(data) {
  console.log('callNumber Done');
  fetchQueueNumbers();
}


// Function to fetch and broadcast current queue number


// Handle socket connections

// Start the server
const port = process.env.PORT || 3206;
server.listen(port, () => {
    console.log(`Socket.io server running on port ${port}`);
});

